$silkupdatehelper="$Env:Programfiles\Steinberg\Activation Manager\silkupdatehelper.exe"
$mediaserverpath="$Env:Programfiles\Steinberg\MediaBay\SteinbergMediaBayServer.exe"
$mediaserver="SteinbergMediaBayServer.exe"

Write-Host "Is $mediaserverpath installed at all..."
IF (-Not (Test-Path -Path $mediaserverpath))
{
	Write-Host "No! Ok to install."
	EXIT 0
}

Write-Host "Ok, now check if silk tools are available..."
IF (-Not (Test-Path -Path $silkupdatehelper))
{
	Write-Host "No! Now rely on system update automatism. reboot might be necessary"
	EXIT 0
}

Write-Host "Ok, now check if media clients are running..."
$code = (Start-Process -FilePath $silkupdatehelper -PassThru -WindowStyle hidden -Wait -ArgumentList "--checkModule mediaclient.dll").ExitCode
IF (-Not ($code -eq 0))
{
	Write-Host "Shutdown of Clients to update..."
	$checkmoduleShutdown = Start-Process -FilePath $silkupdatehelper -PassThru -WindowStyle hidden -Wait -ArgumentList "--checkModule mediaclient.dll --shutdown-module-processes --title MediaBay"
	IF (-Not ($checkmoduleShutdown.ExitCode -eq 0))
	{
		Write-Host "Cancelling installation"
        Write-Error "Cancelling installation"
		EXIT 1
	}

	Write-Host "Ok, now check for running media server..."
	IF (-Not ((Start-Process -FilePath $silkupdatehelper -PassThru -WindowStyle hidden -Wait -ArgumentList "--checkProcess $mediaserver").ExitCode -eq 0))
	{
		Write-Host "Wait for mediabay server to close"
		start-sleep -seconds 5
	}
}

IF (-Not ((Start-Process -FilePath $silkupdatehelper -PassThru -WindowStyle hidden -Wait -ArgumentList "--checkProcess $mediaserver").ExitCode -eq 0))
{
	Write-Host "Shutdown running mediabay server"
	taskkill /F /IM $mediaserver
	start-sleep -seconds 3
}

Write-Host "Ok to install"
EXIT 0

# SIG # Begin signature block
# MIIqJQYJKoZIhvcNAQcCoIIqFjCCKhICAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCCB6gzE1zDFrRbx
# bgNyNor6/j9hAgwpOdIlU2Hnj/ZADaCCDtcwggawMIIEmKADAgECAhAIrUCyYNKc
# TJ9ezam9k67ZMA0GCSqGSIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNV
# BAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMTA0MjkwMDAwMDBaFw0z
# NjA0MjgyMzU5NTlaMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
# ggIKAoICAQDVtC9C0CiteLdd1TlZG7GIQvUzjOs9gZdwxbvEhSYwn6SOaNhc9es0
# JAfhS0/TeEP0F9ce2vnS1WcaUk8OoVf8iJnBkcyBAz5NcCRks43iCH00fUyAVxJr
# Q5qZ8sU7H/Lvy0daE6ZMswEgJfMQ04uy+wjwiuCdCcBlp/qYgEk1hz1RGeiQIXhF
# LqGfLOEYwhrMxe6TSXBCMo/7xuoc82VokaJNTIIRSFJo3hC9FFdd6BgTZcV/sk+F
# LEikVoQ11vkunKoAFdE3/hoGlMJ8yOobMubKwvSnowMOdKWvObarYBLj6Na59zHh
# 3K3kGKDYwSNHR7OhD26jq22YBoMbt2pnLdK9RBqSEIGPsDsJ18ebMlrC/2pgVItJ
# wZPt4bRc4G/rJvmM1bL5OBDm6s6R9b7T+2+TYTRcvJNFKIM2KmYoX7BzzosmJQay
# g9Rc9hUZTO1i4F4z8ujo7AqnsAMrkbI2eb73rQgedaZlzLvjSFDzd5Ea/ttQokbI
# YViY9XwCFjyDKK05huzUtw1T0PhH5nUwjewwk3YUpltLXXRhTT8SkXbev1jLchAp
# QfDVxW0mdmgRQRNYmtwmKwH0iU1Z23jPgUo+QEdfyYFQc4UQIyFZYIpkVMHMIRro
# OBl8ZhzNeDhFMJlP/2NPTLuqDQhTQXxYPUez+rbsjDIJAsxsPAxWEQIDAQABo4IB
# WTCCAVUwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUaDfg67Y7+F8Rhvv+
# YXsIiGX0TkIwHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08wDgYDVR0P
# AQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHcGCCsGAQUFBwEBBGswaTAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUFBzAC
# hjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9v
# dEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAcBgNVHSAEFTATMAcGBWeBDAED
# MAgGBmeBDAEEATANBgkqhkiG9w0BAQwFAAOCAgEAOiNEPY0Idu6PvDqZ01bgAhql
# +Eg08yy25nRm95RysQDKr2wwJxMSnpBEn0v9nqN8JtU3vDpdSG2V1T9J9Ce7FoFF
# UP2cvbaF4HZ+N3HLIvdaqpDP9ZNq4+sg0dVQeYiaiorBtr2hSBh+3NiAGhEZGM1h
# mYFW9snjdufE5BtfQ/g+lP92OT2e1JnPSt0o618moZVYSNUa/tcnP/2Q0XaG3Ryw
# YFzzDaju4ImhvTnhOE7abrs2nfvlIVNaw8rpavGiPttDuDPITzgUkpn13c5Ubdld
# AhQfQDN8A+KVssIhdXNSy0bYxDQcoqVLjc1vdjcshT8azibpGL6QB7BDf5WIIIJw
# 8MzK7/0pNVwfiThV9zeKiwmhywvpMRr/LhlcOXHhvpynCgbWJme3kuZOX956rEnP
# LqR0kq3bPKSchh/jwVYbKyP/j7XqiHtwa+aguv06P0WmxOgWkVKLQcBIhEuWTatE
# QOON8BUozu3xGFYHKi8QxAwIZDwzj64ojDzLj4gLDb879M4ee47vtevLt/B3E+bn
# KD+sEq6lLyJsQfmCXBVmzGwOysWGw/YmMwwHS6DTBwJqakAwSEs0qFEgu60bhQji
# WQ1tygVQK+pKHJ6l/aCnHwZ05/LWUpD9r4VIIflXO7ScA+2GRfS0YW6/aOImYIbq
# yK+p/pQd52MbOoZWeE4wgggfMIIGB6ADAgECAhAKFhGHRfd6aj07c0oz9Oy3MA0G
# CSqGSIb3DQEBCwUAMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwHhcNMjIwNDExMDAwMDAwWhcNMjUwNDEx
# MjM1OTU5WjCB8zETMBEGCysGAQQBgjc8AgEDEwJERTEYMBYGCysGAQQBgjc8AgEC
# EwdIYW1idXJnMRgwFgYLKwYBBAGCNzwCAQETB0hhbWJ1cmcxHTAbBgNVBA8MFFBy
# aXZhdGUgT3JnYW5pemF0aW9uMRIwEAYDVQQFEwlIUkIgODY1MzQxCzAJBgNVBAYT
# AkRFMRAwDgYDVQQHEwdIYW1idXJnMSowKAYDVQQKEyFTdGVpbmJlcmcgTWVkaWEg
# VGVjaG5vbG9naWVzIEdtYkgxKjAoBgNVBAMTIVN0ZWluYmVyZyBNZWRpYSBUZWNo
# bm9sb2dpZXMgR21iSDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAOmy
# 7BWk1JnIRwx5aFlphJViHgmt7ZiaH3BtBBZkolmJ8L9mEfu4xs3ZM6Sa63vR5VHO
# Lq49RXNGE10ZVDVqoP+BoqQTHAAUY8Kiwxd+vA6V7Yo+V2ipmQ9BYjBF9UPC7ywm
# rtQUYOgTyB16fExxZRloZP/kjoHs3YFEbT3iFats4l6kbJYl+NMIDQjRZ+7IuB9f
# vJH8kAI/3UtazJc+apKwbq/6coXDDU6amlpBAYRWry301QBFev0DM2ersiF8Pkps
# tejUNLrI1cpVrcS/EKpqL7L96PqVy/TJ+C0fq5rPD4jUyRtqsDcWqJfmRABX/oe6
# DegnvzI4i9nuau9GpnNFwPZJ25vQ5LrXd+5PYR5wuA2izlt3wtoi1nekTIxKl2QE
# IQBSJZoTXAyoZoUFCWLlZcjBQccHRCGE7ml4zM7MIIQU3nZlm8cxHeLq7qqZ2Tqo
# 7Cr4xdDw3GTkbPRzoslI9MWQBQB8Sat8qI4shguGT4XwIyhZamnPc2VcWjcgHw57
# 2ziX0+8zCMxNeaORoaf6nZ2heeF7tXZS5iv8UJwvxgLGQ1L4nQtNinVxGakVowyQ
# Z+LWiMDsVkBtAhPSRucwazLF1c5uA3j8Fc8Tn2auBbt3kNhU1Srs0E6GwPy4tH+5
# AHsDjQ7srG4LhhDSPZNFuP5S+SymEVgZwe+oZDgBAgMBAAGjggI2MIICMjAfBgNV
# HSMEGDAWgBRoN+Drtjv4XxGG+/5hewiIZfROQjAdBgNVHQ4EFgQU9P3w8pGXUPor
# +3H+eh0bVoydgNQwLwYDVR0RBCgwJqAkBggrBgEFBQcIA6AYMBYMFERFLUhBTUJV
# UkctSFJCIDg2NTM0MA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcD
# AzCBtQYDVR0fBIGtMIGqMFOgUaBPhk1odHRwOi8vY3JsMy5kaWdpY2VydC5jb20v
# RGlnaUNlcnRUcnVzdGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIxQ0Ex
# LmNybDBToFGgT4ZNaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1
# c3RlZEc0Q29kZVNpZ25pbmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcmwwPQYDVR0g
# BDYwNDAyBgVngQwBAzApMCcGCCsGAQUFBwIBFhtodHRwOi8vd3d3LmRpZ2ljZXJ0
# LmNvbS9DUFMwgZQGCCsGAQUFBwEBBIGHMIGEMCQGCCsGAQUFBzABhhhodHRwOi8v
# b2NzcC5kaWdpY2VydC5jb20wXAYIKwYBBQUHMAKGUGh0dHA6Ly9jYWNlcnRzLmRp
# Z2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNENvZGVTaWduaW5nUlNBNDA5NlNI
# QTM4NDIwMjFDQTEuY3J0MAwGA1UdEwEB/wQCMAAwDQYJKoZIhvcNAQELBQADggIB
# ACwZLh8peCgyu9h6Kx6ua9nayNGDzjWh1ZXLIR5HPGJJaLG4fz9WtsfZhcdHJKx6
# RF9qP0t4eVbPxfWkHJmei9SSANAiU4MSIrFf7JMInfNZBumhvj2eJgJyfK9FW964
# JVN5vvQb7HHITpGYLim9cyhGz72FghUf6PzyTqp3p7fm8hwfwtg78NdQyV1ix3px
# 479rg1nPwQ2LYzC4/VBXaHl3QEIQouQbFaeObF/IzljIZZfbFlb3q3X7dkNI9rXi
# Z5PjNGlguWjCAxI0k7Z/DIUBJTAGAioTDE9Iz6jmoiK/yoj7yp6aqtDd+ZHBo1CM
# VGDcq9cs9++/KhpG3gcqxheUvMx+zoRjFjYJpn5tWnzmyymJ8WFn2zx2GWEfxahD
# dEKCr7iyP5bkynTDkB0DbP9bsvkYKmR6RkrZFKRtESrfrCP4IHcYVdLfHsUcEoYb
# I3aIylV7KWGEEtCnzfQN+7n42I8sow/tCNeLDOcuKJtM9ld4XrfyrBxNQ2AEWizo
# ckDaz5B5hTAtUOf2yu6A9gXhAnr8eX0kVd8II04YHQyrkqXF9yx0Q3077DqdMcLx
# ab5unHoKTnmzE8BFDQTkhYnWWWj6+b1ECg7UutKElyatXSvGkCEpazLGPwxbROIX
# E/6S5UKhr5abXmEos4uP7BDLr9FD5yPrXy0uqjzCNAtiMYIapDCCGqACAQEwfTBp
# MQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMT
# OERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBTaWduaW5nIFJTQTQwOTYgU0hBMzg0
# IDIwMjEgQ0ExAhAKFhGHRfd6aj07c0oz9Oy3MA0GCWCGSAFlAwQCAQUAoIG4MBkG
# CSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEE
# AYI3AgEVMC8GCSqGSIb3DQEJBDEiBCCB/vNAt26ZmccdUjhT2nM4rUYzwv9KKaU5
# oAyYOYVPiTBMBgorBgEEAYI3AgEMMT4wPKAegBwAcAByAGUAaQBuAHMAdABhAGwA
# bAAuAHAAcwAxoRqAGGh0dHA6Ly93d3cuU3RlaW5iZXJnLm5ldDANBgkqhkiG9w0B
# AQEFAASCAgBPHIGoPMqzW1yxNh6UFDSvNXsy3cQEjwdPFKWbu1o4XqCoVgXv2AM0
# KWHM+/74mFXkCkC6AvDwEh/58vdhIj0+3NehSfRruKq0HVQlxjcxNiVT2JyGfXoq
# Q5dsnUdWceGWFu0y9grIfz1Saezy0a6QdoWrhp4fwkvJo6XkifshgoJnBr+kzL9Z
# NmwkQNJUkbgQs+HR98BD7vaakfNHxBZq7tDk12IvZjFWAnBkf94ML4g4iRF7qgU/
# XQfnElrISRqlsr6aWd8f1JjtmSBv1P9Jer5mClo0Mn6VlvUlI7Aer2EFb1GNrxq9
# XB8p6ncmARot4zHRJHMakjZ3xOUHiIfxRQQ8pKUMFzas6opuH3R9wYFlfVQ474cy
# 5P6S2XZ3D6NlUjoEjUQFI9qVFtkCmvL2hDgUWG62iW3EZsd6D3dlKisnFCbAVgjj
# nhlTK8byDDBw8klOmbw+jXrU/acnpNuWLDiLDA1fh/+fSl1IeXU9z5GCPHnjOpBa
# kMUTvNRa1Bd506uBccDsbB0UJMmAhh6Tgq/g8oqtsEJfISIqJB/lkz4P8mNQT7vp
# wbvdDxDQ7O+AzjMzteKUnp9XrLj0c1KuPFLPVydKWqmTTiPaEfLGQNf2/QgBiSBs
# pHkic0ZLVWHzshaNf65gDgZK+Dikc2sLlWPUGkV5ajXpa+Xe47WegqGCFz0wghc5
# BgorBgEEAYI3AwMBMYIXKTCCFyUGCSqGSIb3DQEHAqCCFxYwghcSAgEDMQ8wDQYJ
# YIZIAWUDBAIBBQAwdwYLKoZIhvcNAQkQAQSgaARmMGQCAQEGCWCGSAGG/WwHATAx
# MA0GCWCGSAFlAwQCAQUABCA61i0YGPDmn7joZYLAld4hWDDHedndB+kh6GwV6l2l
# 4wIQUEW/7xqaakmBNTBsC32F7RgPMjAyMjEyMDgxMDU0MzRaoIITBzCCBsAwggSo
# oAMCAQICEAxNaXJLlPo8Kko9KQeAPVowDQYJKoZIhvcNAQELBQAwYzELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0y
# MjA5MjEwMDAwMDBaFw0zMzExMjEyMzU5NTlaMEYxCzAJBgNVBAYTAlVTMREwDwYD
# VQQKEwhEaWdpQ2VydDEkMCIGA1UEAxMbRGlnaUNlcnQgVGltZXN0YW1wIDIwMjIg
# LSAyMIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAz+ylJjrGqfJru43B
# DZrboegUhXQzGias0BxVHh42bbySVQxh9J0Jdz0Vlggva2Sk/QaDFteRkjgcMQKW
# +3KxlzpVrzPsYYrppijbkGNcvYlT4DotjIdCriak5Lt4eLl6FuFWxsC6ZFO7Khbn
# UEi7iGkMiMbxvuAvfTuxylONQIMe58tySSgeTIAehVbnhe3yYbyqOgd99qtu5Wbd
# 4lz1L+2N1E2VhGjjgMtqedHSEJFGKes+JvK0jM1MuWbIu6pQOA3ljJRdGVq/9XtA
# bm8WqJqclUeGhXk+DF5mjBoKJL6cqtKctvdPbnjEKD+jHA9QBje6CNk1prUe2nhY
# HTno+EyREJZ+TeHdwq2lfvgtGx/sK0YYoxn2Off1wU9xLokDEaJLu5i/+k/kezbv
# BkTkVf826uV8MefzwlLE5hZ7Wn6lJXPbwGqZIS1j5Vn1TS+QHye30qsU5Thmh1EI
# a/tTQznQZPpWz+D0CuYUbWR4u5j9lMNzIfMvwi4g14Gs0/EH1OG92V1LbjGUKYvm
# QaRllMBY5eUuKZCmt2Fk+tkgbBhRYLqmgQ8JJVPxvzvpqwcOagc5YhnJ1oV/E9mN
# ec9ixezhe7nMZxMHmsF47caIyLBuMnnHC1mDjcbu9Sx8e47LZInxscS451NeX1XS
# fRkpWQNO+l3qRXMchH7XzuLUOncCAwEAAaOCAYswggGHMA4GA1UdDwEB/wQEAwIH
# gDAMBgNVHRMBAf8EAjAAMBYGA1UdJQEB/wQMMAoGCCsGAQUFBwMIMCAGA1UdIAQZ
# MBcwCAYGZ4EMAQQCMAsGCWCGSAGG/WwHATAfBgNVHSMEGDAWgBS6FtltTYUvcyl2
# mi91jGogj57IbzAdBgNVHQ4EFgQUYore0GH8jzEU7ZcLzT0qlBTfUpwwWgYDVR0f
# BFMwUTBPoE2gS4ZJaHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1
# c3RlZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNybDCBkAYIKwYBBQUH
# AQEEgYMwgYAwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBY
# BggrBgEFBQcwAoZMaHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0
# VHJ1c3RlZEc0UlNBNDA5NlNIQTI1NlRpbWVTdGFtcGluZ0NBLmNydDANBgkqhkiG
# 9w0BAQsFAAOCAgEAVaoqGvNG83hXNzD8deNP1oUj8fz5lTmbJeb3coqYw3fUZPwV
# +zbCSVEseIhjVQlGOQD8adTKmyn7oz/AyQCbEx2wmIncePLNfIXNU52vYuJhZqMU
# KkWHSphCK1D8G7WeCDAJ+uQt1wmJefkJ5ojOfRu4aqKbwVNgCeijuJ3XrR8cuOyY
# QfD2DoD75P/fnRCn6wC6X0qPGjpStOq/CUkVNTZZmg9U0rIbf35eCa12VIp0bcrS
# BWcrduv/mLImlTgZiEQU5QpZomvnIj5EIdI/HMCb7XxIstiSDJFPPGaUr10CU+ue
# 4p7k0x+GAWScAMLpWnR1DT3heYi/HAGXyRkjgNc2Wl+WFrFjDMZGQDvOXTXUWT5D
# mhiuw8nLw/ubE19qtcfg8wXDWd8nYiveQclTuf80EGf2JjKYe/5cQpSBlIKdrAqL
# xksVStOYkEVgM4DgI974A6T2RUflzrgDQkfoQTZxd639ouiXdE4u2h4djFrIHprV
# wvDGIqhPm73YHJpRxC+a9l+nJ5e6li6FV8Bg53hWf2rvwpWaSxECyIKcyRoFfLpx
# tU56mWz06J7UWpjIn7+NuxhcQ/XQKujiYu54BNu90ftbCqhwfvCXhHjjCANdRyxj
# qCU4lwHSPzra5eX25pvcfizM/xdMTQCi2NYBDriL7ubgclWJLCcZYfZ3AYwwggau
# MIIElqADAgECAhAHNje3JFR82Ees/ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIxCzAJ
# BgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5k
# aWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAe
# Fw0yMjAzMjMwMDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVTMRcw
# FQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3Rl
# ZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXHJQPE8pE3qZdRodbSg9Ge
# TKJtoLDMg/la9hGhRBVCX6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9/UO0
# hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU5ygt69OxtXXnHwZl
# jZQp09nsad/ZkIdGAHvbREGJ3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0VAsh
# aG43IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECnwHLFuk4fsbVY
# TXn+149zk6wsOeKlSNbwsDETqVcplicu9Yemj052FVUmcJgmf6AaRyBD40NjgHt1
# biclkJg6OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpURK1h0QCir
# c0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD4L/wojzKQtwYSH8UNM/STKvvmz3+
# DrhkKvp1KCRB7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T/jnA
# +bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uKIqjBJgj5FBASA31fI7tk42Pg
# puE+9sJ0sj8eCXbsq11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5rmQzS
# M7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQU
# uhbZbU2FL3MpdpovdYxqII+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6
# mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHcGCCsG
# AQUFBwEBBGswaTAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29t
# MEEGCCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNl
# cnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3Js
# My5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAgBgNVHSAE
# GTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggIBAH1Z
# jsCTtm+YqUQiAX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxpwc8d
# B+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGIdDAiCqBa9qVbPFXONASIlzpVp
# P0d3+3J0FNf/q0+KLHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQcAp8
# 76i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeCRK6ZJxurJB4mwbfeKuv2
# nrF5mYGjVoarCkXJ38SNoOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+jSbl3
# ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fxZsNBzU+2QJshIUDQ
# txMkzdwdeDrknq3lNHGS1yZr5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6OOmc
# 4d0j/R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1ObyF5lZynDwN7+Y
# AN8gFk8n+2BnFqFmut1VwDophrCYoCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR81fZ
# vAT6gt4y3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8mJb2VVQr
# H4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt1nz8MIIFjTCCBHWgAwIBAgIQDpsY
# jvnQLefv21DiCEAYWjANBgkqhkiG9w0BAQwFADBlMQswCQYDVQQGEwJVUzEVMBMG
# A1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSQw
# IgYDVQQDExtEaWdpQ2VydCBBc3N1cmVkIElEIFJvb3QgQ0EwHhcNMjIwODAxMDAw
# MDAwWhcNMzExMTA5MjM1OTU5WjBiMQswCQYDVQQGEwJVUzEVMBMGA1UEChMMRGln
# aUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29tMSEwHwYDVQQDExhE
# aWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
# ggIKAoICAQC/5pBzaN675F1KPDAiMGkz7MKnJS7JIT3yithZwuEppz1Yq3aaza57
# G4QNxDAf8xukOBbrVsaXbR2rsnnyyhHS5F/WBTxSD1Ifxp4VpX6+n6lXFllVcq9o
# k3DCsrp1mWpzMpTREEQQLt+C8weE5nQ7bXHiLQwb7iDVySAdYyktzuxeTsiT+CFh
# mzTrBcZe7FsavOvJz82sNEBfsXpm7nfISKhmV1efVFiODCu3T6cw2Vbuyntd463J
# T17lNecxy9qTXtyOj4DatpGYQJB5w3jHtrHEtWoYOAMQjdjUN6QuBX2I9YI+EJFw
# q1WCQTLX2wRzKm6RAXwhTNS8rhsDdV14Ztk6MUSaM0C/CNdaSaTC5qmgZ92kJ7yh
# Tzm1EVgX9yRcRo9k98FpiHaYdj1ZXUJ2h4mXaXpI8OCiEhtmmnTK3kse5w5jrubU
# 75KSOp493ADkRSWJtppEGSt+wJS00mFt6zPZxd9LBADMfRyVw4/3IbKyEbe7f/LV
# jHAsQWCqsWMYRJUadmJ+9oCw++hkpjPRiQfhvbfmQ6QYuKZ3AeEPlAwhHbJUKSWJ
# bOUOUlFHdL4mrLZBdd56rF+NP8m800ERElvlEFDrMcXKchYiCd98THU/Y+whX8Qg
# UWtvsauGi0/C1kVfnSD8oR7FwI+isX4KJpn15GkvmB0t9dmpsh3lGwIDAQABo4IB
# OjCCATYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQU7NfjgtJxXWRM3y5nP+e6
# mK4cD08wHwYDVR0jBBgwFoAUReuir/SSy4IxLVGLp6chnfNtyA8wDgYDVR0PAQH/
# BAQDAgGGMHkGCCsGAQUFBwEBBG0wazAkBggrBgEFBQcwAYYYaHR0cDovL29jc3Au
# ZGlnaWNlcnQuY29tMEMGCCsGAQUFBzAChjdodHRwOi8vY2FjZXJ0cy5kaWdpY2Vy
# dC5jb20vRGlnaUNlcnRBc3N1cmVkSURSb290Q0EuY3J0MEUGA1UdHwQ+MDwwOqA4
# oDaGNGh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3VyZWRJRFJv
# b3RDQS5jcmwwEQYDVR0gBAowCDAGBgRVHSAAMA0GCSqGSIb3DQEBDAUAA4IBAQBw
# oL9DXFXnOF+go3QbPbYW1/e/Vwe9mqyhhyzshV6pGrsi+IcaaVQi7aSId229GhT0
# E0p6Ly23OO/0/4C5+KH38nLeJLxSA8hO0Cre+i1Wz/n096wwepqLsl7Uz9FDRJtD
# IeuWcqFItJnLnU+nBgMTdydE1Od/6Fmo8L8vC6bp8jQ87PcDx4eo0kxAGTVGamlU
# sLihVo7spNU96LHc/RzY9HdaXFSMb++hUD38dglohJ9vytsgjTVgHAIDyyCwrFig
# DkBjxZgiwbJZ9VVrzyerbHbObyMt9H5xaiNrIv8SuFQtJ37YOtnwtoeW/VvRXKwY
# w02fc7cBqZ9Xql4o4rmUMYIDdjCCA3ICAQEwdzBjMQswCQYDVQQGEwJVUzEXMBUG
# A1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQg
# RzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAMTWlyS5T6PCpKPSkH
# gD1aMA0GCWCGSAFlAwQCAQUAoIHRMBoGCSqGSIb3DQEJAzENBgsqhkiG9w0BCRAB
# BDAcBgkqhkiG9w0BCQUxDxcNMjIxMjA4MTA1NDM0WjArBgsqhkiG9w0BCRACDDEc
# MBowGDAWBBTzhyJNhjOCkjWplLy9j5bp/hx8czAvBgkqhkiG9w0BCQQxIgQgytLv
# yReEgZv5+Nu4nBFZ9E0wJIEX9dDyG4602cz5LkwwNwYLKoZIhvcNAQkQAi8xKDAm
# MCQwIgQgx/ThvjIoiSCr4iY6vhrE/E/meBwtZNBMgHVXoCO1tvowDQYJKoZIhvcN
# AQEBBQAEggIAKRqanFk7h+Z7llaMgqXiXN8uJmoKMjoGc2kCltniqNypieYTy9tP
# 8bZfZDUUxSzzA0CzctVIS4gdsYtGV0N1JcnwJUGzpSsbJYSwASFeGNalORMrMuEt
# r1i+qIQw68KBHNFOAmwHF5KOnhiDV/UDXuv9YLs1s7pt2Pn7bhpsq3fhbPLLvbxQ
# qwOlvTS5iOTVJ3xAp7MfDPALVQ2XQuuYzyeLdPXuFrKWBRMcl7+zs0uDsKXy3Agu
# ite3K6SPERo8fKOfBIJfDcZilYwSFetRX11BGWWjvlO94DZoFwY8za5byMuVEEr6
# ufExwUpAbFzqghSgu7goUChRXszCPTluHMsbH4Pqi7Vc4rVZhv77eJ3rktOUE5rb
# L9WO+C2poPNlkWRETXryR91B8Co5E1rthoYbl+nM+NT81v+U/58NvCeXwu01zTem
# IgIDmQOM+S+t5iewEidqb+YxHqX/hcsHhuG4QLaNVmuCi1OMsrwIAN9uGihJ4wie
# StP+Ud1agKXeZBXdu4KX/L+UohaMBhgLLI+KMy8reaUuM0b+TeIM0OR4r+Oa+zNF
# uIjVOUkhWsRAGzFToc/SIdqZCkN5vd7lEpmKEpO2ky9FScCRsurwgQYFgKjBjEVn
# TWrpAn0zPOCstAIs4OmJq/s1XTzZCDyF2w+/lMXuG2ksy7Xa19XF8Eo=
# SIG # End signature block
